﻿/*
VERSION:	1.4
	1.4		Isolated hit-box size settings.
	1.3		Fix:  Made this work at arbitrary scales.  Use localToGlobal() on each player collision-point.
	1.2		Made these collision checks more efficient by moving player-positon calculations outside of the sprite-loop
				Collisions are based on the sizes of the player's "hit" movieClip and each sprite's "hit" movieClip

DECRIPTION:
	This system is meant to be used with the  walkInertia.as  style of movement.
	It collides with other movieClips on the sprite layer.
	
NOTE:
	If a sprite contains "noCollide" and it's set to true,
	then it won't collide with the player.

AVAILABLE DATA:
	This returns a collision function which changes its parent's objects & properties.
	The parent collision system (this) contains:
		xOffset, yOffset
		player_mc
			_x, _y
		collision_array
		walk_obj
			xVel, yVel
	
*/
function makeSpriteCollision()
{
	var collision_funct = function()
	{
		var player_mc = this.player_mc;
		// define player's size
		var sizeDivider = 2;		// 2
		var defaultHitboxSize = 4;
		var pWidth = (this.player_mc.hit._width/sizeDivider) || defaultHitboxSize;
		var pHeight = (this.player_mc.hit._height/sizeDivider) || defaultHitboxSize;
		// allow an arbitrary position offset for collision-check's
		var xOffset = this.xOffset;
		var yOffset = this.yOffset;
		
		// extract velocities
		var xVel = this.walk_obj.xVel;
		var yVel = this.walk_obj.yVel;
		
		// get directions
		var xDir = Math.abs(xVel) / xVel;
		var yDir = Math.abs(yVel) / yVel;
		
		// pre-determine which player-locations to collide with
		var checkHorz = [];
		var checkVert = [];
		var pos;
		if(xDir){
			// top
			pos = new flash.geom.Point( player_mc._x +(pWidth*xDir) +xVel -xOffset,   player_mc._y -pHeight -yOffset );
			SPRITES.localToGlobal(pos);
			checkHorz.push( pos );
			// bottom
			pos = new flash.geom.Point( player_mc._x +(pWidth*xDir) +xVel -xOffset,   player_mc._y +pHeight -yOffset );
			SPRITES.localToGlobal(pos);
			checkHorz.push( pos );
		}// if:  moving horz
		
		if(yDir){
			// left
			pos = new flash.geom.Point( player_mc._x -pWidth -xOffset,   player_mc._y +(pHeight*yDir) +yVel -yOffset );
			SPRITES.localToGlobal(pos);
			checkVert.push( pos );
			// right
			pos = new flash.geom.Point( player_mc._x +pWidth -xOffset,   player_mc._y +(pHeight*yDir) +yVel -yOffset );
			SPRITES.localToGlobal(pos);
			checkVert.push( pos );
		}// if:  moving horz
		
		
		// check those player-locations with each sprite... until collision occurs
		for(var nam in this.spriteLayer_mc)
		{
			var thisSprite = this.spriteLayer_mc[nam];
			if(thisSprite === player_mc)		continue;
			if(thisSprite.noCollide === true)		continue;
			if(thisSprite.hit === undefined)		continue;
			
			// horz
			for(var p=0; p<checkHorz.length; p++)
			{
				var check_p = checkHorz[p];
				if( thisSprite.hit.hitTest( check_p.x, check_p.y, false ) )
				{// if:  any collision occurs horizontally
					// reset horz velocity
					this.walk_obj.xVel = 0;
					// stop checking horizontal collision
					break;
				}// if:  any collision occurs horizontally
			}// for:  each player collision-point to check
			
			
			// vert
			for(var p=0; p<checkVert.length; p++)
			{
				var check_p = checkVert[p];
				if( thisSprite.hit.hitTest( check_p.x, check_p.y, false ) )
				{// if:  any collision occurs vertically
					// reset horz velocity
					this.walk_obj.yVel = 0;
					// stop checking vertical collision
					break;
				}// if:  any collision occurs vertically
			}// for:  each player collision-point to check
			
			// if:  the player has collided
			if(this.walk_obj.xVel == 0 && this.walk_obj.yVel == 0){
				// stop checking collision with sprites
				break;
			}// if:  player has collided
			
		}// for...in:  spriteLayer_mc
	}// collision_funct()
	
	return collision_funct;
}// makeSpriteCollision()